package de.test.webrequest;

import java.util.Vector;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler extends DefaultHandler {

	private User user = new User(0, null, null);
	private Vector<User> users = new Vector<User>();

	private boolean in_id = false;
	private boolean in_name = false;
	private boolean in_key = false;

	/**
	 * Returns the vector of parsed User-Objects
	 * 
	 * @return Vector of UserObj
	 */
	public Vector<User> getUserData() {
		return this.users;
	}

	/**
	 * Creates the local objects when called
	 */
	@Override
	public void startDocument() throws SAXException {
		this.user = new User(0, null, null);
	}

	/**
	 * Does nothing when called
	 */
	@Override
	public void endDocument() throws SAXException {
		// Nothing to do
	}

	/**
	 * Gets called on opening tags like: <tag>
	 */
	@Override
	public void startElement(String namespaceURI, String localName,
			String qName, Attributes atts) throws SAXException {
		if (localName.equals("id")) {
			this.in_id = true;
		} else if (localName.equals("name")) {
			this.in_name = true;
		} else if (localName.equals("key")) {
			this.in_key = true;
		}
	}

	/**
	 * Gets called on closing tags like: </tag>
	 */
	@Override
	public void endElement(String namespaceURI, String localName, String qName)
			throws SAXException {
		if (localName.equals("id")) {
			this.in_id = false;
		} else if (localName.equals("name")) {
			this.in_name = false;
		} else if (localName.equals("key")) {
			this.in_key = false;
		} else if (localName.equals("user")) {
			this.users.add(this.user);
			this.user = new User(0, null, null);
		}
	}

	/**
	 * Gets called on the following structure: <tag>characters</tag>
	 * 
	 * @param ch
	 *            [] The character-array of the structure
	 * @param start
	 *            The first character of the content
	 * @param length
	 *            The length of the content
	 */
	@Override
	public void characters(char ch[], int start, int length) {
		if (this.in_id) {
			user.setId(Integer.parseInt(new String(ch, start, length)));
		} else if (this.in_name) {
			user.setName(new String(ch, start, length));
		} else if (this.in_key) {
			user.setKey(new String(ch, start, length));
		}
	}
}